﻿var caseAssignmentRules = {
    context: $(".v-caseAssignmentRules"),
    datatable: null,
    changeCategoryItems: null,
    refreshDataTable: function () {
        caseAssignmentRules.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".h-caseAssignmentRulesTable", caseAssignmentRules.context).a4datatable({
            ajaxAction: a4.getSurveyAction("GetCaseAssignmentRules", "Offline"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Visible": false, "Class": "id" },
                { "Name": "Name", "Title": resources.RuleName, "Data": "Name" },
                { "Name": "User", "Title": resources.User, "Data": "User" },
                { "Name": "Rule", "Title": resources.Rule, "Data": "RuleDisplay" },
                { "Name": "Active", "Title": resources.Active, "Data": "ActiveLabel" },
                { "Name": "Priority", "Title": resources.Priority, "Data": "Priority" },
                { "Name": "CreatedOn", "Title": resources.CreatedOn, "Data": "CreatedOn" },
                { "Name": "ModifiedOn", "Title": resources.ModifiedOn, "Data": "ModifiedOn" }
            ],
            localizableTexts: { "Search": resources.SearchCaseAssignmentRules },
            defaultSorting: { Column: "ModifiedOn", Ascending: false },
            stateKey: "CaseAssignmentRules",
            toolBarItems: [{ "Action": "delete", "Label": resources.Delete }],
            contextMenuItems: [
                { "Action": "delete", "Label": resources.Delete },
                { "Action": "properties", "Label": resources.Properties }]
            ,
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = [];

                for (var i = 0; i < rows.length; i++) {
                    ids.push(rows[i].Id);
                }

                switch (action) {
                    case "delete":
                        caseAssignmentRules.deleteItems(rows[0].Name, ids);
                        break;
                }
            },
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "properties":
                        caseAssignmentRules.editItem(row.Id);
                        break;
                    case "delete":
                        caseAssignmentRules.deleteItems(row.Name, row.Id);
                        break;
                }
            }
        });
    },
    deleteItems: function (name, items) {
        var rule = name;
        var res = confirmDeleteMultipleResources;

        var itemsCount = items.length;

        if (itemsCount === undefined) {
            itemsCount = 1;
        }

        if (itemsCount == 1) {
            res = confirmDeleteResources;
        }

        modalDialog.showConfirmDialog(res, function () {
            a4.callServerMethod(a4.getSurveyAction("DeleteCaseAssignmentRules", "Offline"), { itemIds: items },
            function (result) {
                caseAssignmentRules.refreshDataTable();
            });
        }, 250, 500, true, { "count": itemsCount, "rule": rule });
    },
    editItem: function (itemId) {
        modalDialog.showWindow(a4.getSurveyAction("CaseAssignmentRuleEditor", "Offline", { ruleId: itemId }), 550, 1100, { afterClose: caseAssignmentRules.refreshDataTable });
    },
    bindEvents: function () {
        $(".h-addCAR", caseAssignmentRules.context).on("click", function () {
            modalDialog.showWindow(a4.getSurveyAction("CaseAssignmentRuleEditor", "Offline", { ruleId: 0 }), 550, 1100, { afterClose: caseAssignmentRules.refreshDataTable });
        });
    }
}

$(document).ready(function () {
    if (caseAssignmentRules.context.length > 0) {
        caseAssignmentRules.initializeDataTable();
        caseAssignmentRules.bindEvents();

        caseAssignmentRules.context.on("click", ".h-copyRules", function () {
            modalDialog.showWindow(a4.getSurveyAction("CopyRules", "Offline"), 250, 600, { afterClose: caseAssignmentRules.refreshDataTable });
        });
    }
});